using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Text;
using CommandLine;
using CommandLine.Text;

namespace ReadText.LocalizedDemo
{
    class Program
    {
        public static int Main(string[] args)
        {
            //Czech (cs)
            System.Threading.Thread.CurrentThread.CurrentCulture = new CultureInfo("cs", false);
            System.Threading.Thread.CurrentThread.CurrentUICulture = new CultureInfo("cs", false);
           
            // Set sentence builder to localizable
            SentenceBuilder.Factory = () => new LocalizableSentenceBuilder();

            Func<IOptions, string> reader = opts =>
                {
                    var fromTop = opts.GetType() == typeof(HeadOptions);
                    return opts.Lines.HasValue
                        ? ReadLines(opts.FileName, fromTop, (int)opts.Lines)
                        : ReadBytes(opts.FileName, fromTop, (int)opts.Bytes);
                };
            Func<IOptions, string> header = opts =>
                {
                    if (opts.Quiet)
                    {
                        return string.Empty;
                    }
                    var fromTop = opts.GetType() == typeof(HeadOptions);
                    var builder = new StringBuilder(Properties.Resources.Reading);
                    builder = opts.Lines.HasValue
                        ? builder.Append(opts.Lines).Append(Properties.Resources.Lines)
                        : builder.Append(opts.Bytes).Append(Properties.Resources.Bytes);
                    builder = fromTop ? builder.Append(Properties.Resources.FromTop) : builder.Append(Properties.Resources.FromBottom);
                    return builder.ToString();
                };
            Action<string> printIfNotEmpty = text =>
                {
                    if (text.Length == 0) { return; }
                    Console.WriteLine(text);
                };

            var result = Parser.Default.ParseArguments<HeadOptions, TailOptions>(args);
            var texts = result
                .MapResult(
                    (HeadOptions opts) => Tuple.Create(header(opts), reader(opts)),
                    (TailOptions opts) => Tuple.Create(header(opts), reader(opts)),
                    _ => MakeError());

            printIfNotEmpty(texts.Item1);
            printIfNotEmpty(texts.Item2);

            return texts.Equals(MakeError()) ? 1 : 0;
        }

        private static string ReadLines(string fileName, bool fromTop, int count)
        {
            var lines = File.ReadAllLines(fileName);
            if (fromTop)
            {
                return string.Join(Environment.NewLine, lines.Take(count));
            }
            return string.Join(Environment.NewLine, lines.Reverse().Take(count));
        }

        private static string ReadBytes(string fileName, bool fromTop, int count)
        {
            var bytes = File.ReadAllBytes(fileName);
            if (fromTop)
            {
                return Encoding.UTF8.GetString(bytes, 0, count);
            }
            return Encoding.UTF8.GetString(bytes, bytes.Length - count, count);
        }

        private static Tuple<string, string> MakeError()
        {
            return Tuple.Create("\0", "\0");
        }
    }
}
